%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% heuristic                                                               %
%                                                                         %
% Thomas Linke, Christian Anger, Martin Gebser                            %
%                                                                         %
% last edit: Sep, 2002                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 
% choose_first_uncolored(-Node,+CPin,-CPout,+Col,+NextLevelI,-NextLevelO)
% is true iff Node is the next choice from CPin; gives new choices CPout.
%                 -     +     -      +    +           -
heuristic_choose( Node, CPin, CPout, Col, NextLevelI, NextLevelO ):-
	(
	    get_flag(lookahead) ->
	    (
		writeln(dolookahead),
		writeln('lookahead not implemented'),
		!,fail
	    );
	    (
		choose_first_uncolored(Node,CPin,CPout,Col),!,
		NextLevelO = NextLevelI
	    )
	).

%                        -   +      -   +
choose_first_uncolored( no, [],    [], _Col ) :- !.
choose_first_uncolored( N,  [N|R], R,  Col ) :- 
	is_u(N,Col),
	!.
choose_first_uncolored( N, [_|R1], R, Col ) :- 
	choose_first_uncolored(N,R1,R,Col).

%
% heuristic orders for rules, bodies and heads
%
heuristic_sort_rule(LP,LP1) :- 
	sort(LP,LP1).

heuristic_sort_b(Bs,Bs1) :- 
	sort(Bs,Bs1).

heuristic_sort_h(Hs,Hs1) :- 
	sort(Hs,Hs1).
