/*
 * $Id: nop_stream.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 * Copyright 2005 Benjamin Kaufmann
 */ 
#ifndef NOP_STREAM_H
#define NOP_STREAM_H

#include <iostream>
#include <cassert>
///////////////////////////////////////////////////////////////////////////////
// class NopStream
///////////////////////////////////////////////////////////////////////////////
class NopStream
{
public:
	explicit
	NopStream(std::ostream* str = 0, bool enable = false)
		:	str_(str)
		,	enable_(enable)
	{}
	inline bool print() const { return enable_; }
	inline void enable() { enable_ = true; }
	inline void disable() { enable_ = false; }
	inline std::ostream& str()
	{
		assert(str_);
		return *str_;
	}
	inline void str(std::ostream& os)
	{
		str_ = &os;
	}
private:
	std::ostream* str_;
	bool enable_;
};


// Do-nothing operator << for NopStream. 
template<class T>
inline NopStream& operator<<(NopStream& s, const T& t)
{
    if (s.print())
    	s.str() << t;
    return s;
}

// operator << that handels ostream-manipulators like std::endl
inline NopStream& operator<<(NopStream& s, std::ostream& (*p)(std::ostream&))
{
    if (s.print())
    	s.str() << p;
    return s;
}
///////////////////////////////////////////////////////////////////////////////

#endif
