#include <nomore/graph_cloner.h>
#include <nomore/libnomore/include/head_node.h>
#include <nomore/libnomore/include/body_node.h>
#include <cassert>

#if defined (_MSC_VER) && _MSC_VER <= 1300
#define for if (0) ; else for
#endif


namespace NS_NOMORE {

GraphCloner::GraphCloner() {

}

GraphCloner::~GraphCloner() {

}


Graph* GraphCloner::clone(const Graph& toClone) {
  reset();
  initToClone(toClone);
  
  // first clone all nodes...
  for (size_t i = 0; i != toClone.countNodes(); ++i) {
      Node* n = toClone.getNode(i);
      clonedNodes_.push_back(NodePair(n, insertCorresponding(n)));
  }
  
  
  // ...then establish relations...
  size_t maxNode = clonedNodes_.size();
  for (size_t i = 0; i != maxNode; ++i) {
    addSuccessors(clonedNodes_[i]);
    // ...and finally set the color
    if (clonedNodes_[i].first->getColor() != Color::none) {
      theClone_->color(*clonedNodes_[i].second, clonedNodes_[i].first->getColor());
    }
  }
  return theClone_.release();  
}

void GraphCloner::reset() {
  theClone_.reset(new Graph);
  toClone_ = 0;
  std::vector<NodePair>().swap(clonedNodes_);
}

void GraphCloner::initToClone(const Graph& toClone) {
  toClone_ = &toClone;
  clonedNodes_.reserve(toClone.countNodes());
}


void GraphCloner::addSuccessors(const NodePair& p) {
  if (dynamic_cast<HeadNode*>(p.first)) {
    addSuccessors(static_cast<HeadNode*>(p.first), static_cast<HeadNode*>(p.second));
  }
  else if (dynamic_cast<BodyNode*>(p.first)) {
    addSuccessors(static_cast<BodyNode*>(p.first), static_cast<BodyNode*>(p.second));
  }
  else {
    assert(!"Ups - unknown node type!");
  }
}

void GraphCloner::addSuccessors(BodyNode* original, BodyNode* clone) {
  for (BodyNode::HeadNodeIterator it = original->successorsBegin(); it != original->successorsEnd(); ++it) {
    assert( (*it)->getId() < clonedNodes_.size());

    HeadNode* n = static_cast<HeadNode*>(clonedNodes_[(*it)->getId()].second);
    clone->insertSuccessor(*n);
  }
}

void GraphCloner::addSuccessors(HeadNode* original, HeadNode* clone) {
  for (HeadNode::BodyNodeIterator it = original->zeroSuccessorsBegin(); it != original->zeroSuccessorsEnd(); ++it) {
    assert( (*it)->getId() < clonedNodes_.size());
    BodyNode* n = static_cast<BodyNode*>(clonedNodes_[(*it)->getId()].second);
    clone->insertZeroSuccessor(*n);
  }

  for (HeadNode::BodyNodeIterator it = original->oneSuccessorsBegin(); it != original->oneSuccessorsEnd(); ++it) {
    assert( (*it)->getId() < clonedNodes_.size());
    BodyNode* n = static_cast<BodyNode*>(clonedNodes_[(*it)->getId()].second);
    clone->insertOneSuccessor(*n);
  }
}


Node* GraphCloner::insertCorresponding(Node* original) {
  Node* clone = 0;
  if (HeadNode* h = dynamic_cast<HeadNode*>(original)) {
    clone = theClone_->insertHeadNode(h->getAtomId());
    static_cast<HeadNode*>(clone)->setAtomName(h->getAtomName());
  }
  else {
     clone = theClone_->insertBodyNode();
  }
  clone->setComponentNumber(original->getComponentNumber());
  return clone;
}

}
