/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <heuristic.h>
#include <graph.h>
#include <algorithm>

namespace NS_NOMORE {

Heuristic::Heuristic() {}
Heuristic::~Heuristic() {}
void Heuristic::setGraph(Graph&) {}
  
SelectFirst::SelectFirst() : graph_(0) {}

void SelectFirst::setGraph(Graph& g) {
  graph_ = &g;
}

Node* SelectFirst::selectNode(const Constraint& c) {
  assert(graph_);
  for (Graph::UncoloredNodeIterator it = graph_->uncoloredNodesBegin(); it != it.end(); ++it) {
    if (c.isSatisfiedBy(**it)) {
      return *it;
    }
  }
  return 0;
}

}

