#ifndef NOMORE_PROGRAM_IMPL_H_INCLUDED
#define NOMORE_PROGRAM_IMPL_H_INCLUDED
#include <platypus/types/program.h>

namespace NS_NOMORE {
class Graph;
class Operator;

}

namespace Platypus { namespace Nomore { 

class ProgramImpl
{
public:
    typedef Platypus::ProgramInterface::CollectionType CollectionType;
    ProgramImpl();
    ~ProgramImpl();
    void setup(std::istream& is);
    const std::string& idToName(AtomId id) const;
    const CollectionType& atoms() const;
    size_t numberOfAtoms() const;
    size_t numberOfRules() const;
    bool hasDisplayName(AtomId) const;

    
    // interface to be used by the Nomore::Expander
    bool needsUOperator() const
    {
        return noUOperator_ == false;
    }
    bool hasConflict() const
    {
        return hasConflict_;
    }
    NS_NOMORE::Graph* cloneGraph() const;

private:
    ProgramImpl(const ProgramImpl&);
    ProgramImpl& operator=(const ProgramImpl&);

    NS_NOMORE::Operator* createOperators() const;
    void initAtoms();
    inline void validate(AtomId id) const;

    CollectionType atoms_;
    std::auto_ptr<NS_NOMORE::Graph>    graph_;
    bool hasConflict_;
    bool noUOperator_;
};
    

}}
#endif
