#include "uname.h"

#ifdef PT_HAVE_WIN32

static const char* const PT_MACHINE = "i586";

// make sure MINGW32 is compiling this
#ifdef __MINGW32__
static const char* const PT_SYSTEM = "MINGW32";
int uname(utsname* data)
{
	data->machine = PT_MACHINE;
	data->nodename = "";
	data->release = "";
	data->sysname = PT_SYSTEM;
	data->version = "";
	return 0;
}
#endif

// Microsoft's compilers
#ifdef _MSC_VER
static const char* const PT_SYSTEM = "Win32";
int uname(utsname* data)
{
	data->machine = PT_MACHINE;
	data->nodename = "";
	data->release = "";
	data->sysname = PT_SYSTEM;
	data->version = "";
	return 0;
}
#endif

#endif // HAVE_WIN32


