#include <xplib/xplib-dll.h>
#include <platypus/factories/distribution_factory.h>
#include <platypus/options_faker.h>
#include <program_options/value.h>
#include <distribution/fork/fork.h>

using namespace Platypus;

static unsigned counter = 0;

XPLIB_DLL_EXPORT void platypus_dll_initialize()
{
	if(counter++ == 0)
	{
		DistributionFactory::instance().add("fork", Fork::create, "Distribution via forking");
		OptionsFaker::instance().options().addOptions()
			("processes,p", ProgramOptions::value<int>()->defaultValue(2), "# processes to use with forking");
	}	
}

XPLIB_DLL_EXPORT void platypus_dll_finalize()
{}



