/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MANUAL_EMPTY_BITS_POINTER_CAS_H
#define MANUAL_EMPTY_BITS_POINTER_CAS_H

#define PT_POINTER_CAS_INCLUDED

PT_NAMESPACE_BEGIN

namespace PTPrivate
{
	template<class Traits>
	class PointerCAS
	{
	public:
		typedef pt_pointer_type int_t;
		typedef PTPrivate::token_t token_t;
	public:
		explicit
		PointerCAS(int_t v = 0)
			:	value_(0)
		{
			assign(v);
		}
		inline bool cas(int_t nv, const token_t& ov)
		{
			return pt_atomic_cas(
				&value_,
				Traits::multiplex(nv, ov.count()+1),
				Traits::multiplex(ov.value(), ov.count()));
		}
		inline token_t get() const
		{
			const int_t v = value_;
			return token_t(Traits::value(v), Traits::count(v));
		}
		inline void assign(int_t v)
		{
			value_ = Traits::multiplex(v, Traits::count(value_));
		}
	private:
		PointerCAS(const PointerCAS&);
		PointerCAS operator=(const PointerCAS&);
	private:
		volatile int_t value_;
	};
}

PT_NAMESPACE_END

#endif
