
#ifndef ANSWER_SETS_H
#define ANSWER_SETS_H

#include <string>
#include <deque>
#include <vector>
#include <stdexcept>
#include <map>
#include <iosfwd>
#include <smartpointer.h>


namespace Regression
{
	struct ParseError : public std::runtime_error
	{
		ParseError(const std::string& reason = "Error in input")
			:	std::runtime_error(reason)
		{}
	};

	class AnswerSets
	{
	public:
		typedef toolbox::SharedPtr<AnswerSets> AnswerSetsPtr;
		typedef std::vector<std::string> StringArray;
		~AnswerSets();
		AnswerSets(std::istream& input, bool processed = false);
		bool isAnswerSet(const StringArray& as) const;
		size_t size() const;
		void store(std::ostream& os) const;
	private:
		AnswerSets();
		void readSmodelsOutput(std::istream& input);
		void readInternalFormat(std::istream& input);
	private:
		typedef std::deque<size_t> AnswerSet;
		typedef std::deque<AnswerSet> MultipleAnswerSets;
		typedef std::map<std::string, size_t> Dictionary;
		Dictionary dictionary_;
		MultipleAnswerSets answerSets_;
	};
}

#endif

