// $Id: test_choices_to_do.cpp 1778 2005-05-17 14:37:06Z jgressma $

#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/program_metadata.h>
#include <platypus/types.h>
#include <platypus/types/search_space.h>


using namespace std;
using namespace Platypus;

class SearchSpaceTest : public CppUnit::TestFixture
{
public:
	void testEmpty()
	{
		SearchSpace space;
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
		space.close(space.root());
		CPPUNIT_ASSERT_EQUAL(true, space.empty());
	}
	void initializeFromBranch()
	{
		Branch b;
		b.push_back(Choice(1, true));
		b.push_back(Choice(2, true));
		b.push_back(Choice(3, false));
		SearchSpace space(b);

		CPPUNIT_ASSERT_EQUAL(false, space.empty());

		SearchSpace::cursor c3 = space.root().descend_left().descend_left().descend_right();
		CPPUNIT_ASSERT_EQUAL(static_cast<ChoiceId>(3), c3->id());
		CPPUNIT_ASSERT_EQUAL(true, c3.has_parent());
		CPPUNIT_ASSERT_EQUAL(false, c3.has_left_child());
		CPPUNIT_ASSERT_EQUAL(false, c3.has_right_child());

		SearchSpace::cursor c2 = c3.parent();
		CPPUNIT_ASSERT_EQUAL(static_cast<ChoiceId>(2), c2->id());
		CPPUNIT_ASSERT_EQUAL(true, c2.has_parent());
		CPPUNIT_ASSERT_EQUAL(false, c2.has_left_child());
		CPPUNIT_ASSERT_EQUAL(true, c2.has_right_child());

		SearchSpace::cursor c1 = c2.parent();
		CPPUNIT_ASSERT_EQUAL(static_cast<ChoiceId>(1), c1->id());
		CPPUNIT_ASSERT_EQUAL(true, c1.has_parent());
		CPPUNIT_ASSERT_EQUAL(true, c1.has_left_child());
		CPPUNIT_ASSERT_EQUAL(false, c1.has_right_child());

		CPPUNIT_ASSERT(c1.parent() == space.root());
	}
	void addEmptyBranch()
	{
		SearchSpace space;
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
		space.close(space.root());
		CPPUNIT_ASSERT_EQUAL(true, space.empty());
		space.integrate(Branch());
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
	}
	
	void addBranch()
	{
		Branch b;
		b.push_back(Choice(1, true));
		b.push_back(Choice(2, true));
		b.push_back(Choice(3, false));
		SearchSpace space(b);

		SearchSpace::cursor c = space.root();
		c.descend_left();
		CPPUNIT_ASSERT_EQUAL(false, c.has_right_child());
		
		b[1].toggle();
		
		space.integrate(b);

		CPPUNIT_ASSERT_EQUAL(true, c.has_right_child());
	}
	
	void closeBranch()
	{
		Branch b;
		b.push_back(Choice(1, true));
		b.push_back(Choice(2, true));
		b.push_back(Choice(3, false));
		SearchSpace space(b);

		
		SearchSpace::cursor end = space.root().descend_left().descend_left().descend_right();
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
		space.close(end);
		CPPUNIT_ASSERT_EQUAL(true, space.empty());

		SearchSpace::cursor c1 = space.integrate(b);

		CPPUNIT_ASSERT_EQUAL(false, space.empty());
		b[1].toggle();
		SearchSpace::cursor c2 = space.integrate(b);

		// set active branch so it is clear which one to close
		space.close(c1);
		
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
	}

	void getBranch()
	{
		Branch b;
		b.push_back(Choice(1, true));
		b.push_back(Choice(2, true));
		b.push_back(Choice(3, false));
		SearchSpace space(b);

		Branch empty = space.branch(space.root());
		Branch branch = space.branch(space.root().descend_left().descend_left().descend_right());
		CPPUNIT_ASSERT(Branch() == empty);
		CPPUNIT_ASSERT(branch == b);

		Branch foo;
		foo.push_back(Choice(2, true));
		foo.push_back(Choice(3, false));
		SearchSpace::cursor end = space.root().descend_left().descend_left().descend_right();
		Branch bar = space.branch(end, space.root().descend_left());
		CPPUNIT_ASSERT(foo == bar);
	}

	void addChoice()
	{
		SearchSpace space;

		SearchSpace::cursor now = space.add(space.root(), Choice(1, true));
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
		space.close(now);
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
		space.close(space.root().descend_right());
		CPPUNIT_ASSERT_EQUAL(true, space.empty());

	}
	void extractBranch()
	{
		Branch b;
		b.push_back(Choice(1, true));
		b.push_back(Choice(2, true));
		b.push_back(Choice(3, false));
		SearchSpace space(b);

		b[1].toggle();
		
		space.integrate(b);

		SearchSpace::cursor c = space.root();
		c.descend_left();
		CPPUNIT_ASSERT(Branch() == space.extract(c));
		c.descend_right().descend_right();
		
		Branch foo = space.extract(c);
		CPPUNIT_ASSERT(b == foo);
		CPPUNIT_ASSERT_EQUAL(false, space.empty());
	}

	CPPUNIT_TEST_SUITE( SearchSpaceTest );
		CPPUNIT_TEST( testEmpty );
		CPPUNIT_TEST( initializeFromBranch );
		CPPUNIT_TEST( addEmptyBranch );
		CPPUNIT_TEST( addBranch );
		CPPUNIT_TEST( closeBranch );
		CPPUNIT_TEST( getBranch );
		CPPUNIT_TEST( addChoice );
		CPPUNIT_TEST( extractBranch );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( SearchSpaceTest );


