#ifndef PRINTER_THREAD_H
#define PRINTER_THREAD_H

#include <iosfwd>
#include <portablethreads/thread.h>

namespace Platypus
{
	class PartialAssignment;
	class AnswerSetPrinterBase;
	class PrinterThreadCallback
	{
	public:
		virtual ~PrinterThreadCallback()
		{}
		virtual bool retrieveAnswerSetForPrinting(PartialAssignment& pa) = 0;
	};

	class ProgramInterface;
	class PrinterThread : public PortableThreads::PThread
	{
	public:
		~PrinterThread();
		PrinterThread(	PrinterThreadCallback& callback, 
						const ProgramInterface& program, 
						AnswerSetPrinterBase& printer, 
						size_t requested_answersets,
						// iteration delay in ms 
						unsigned delay = 50);
		// shuts down thread next time
		// an answer set could not be retrieved 
		// (assuming this means no more as to print)
		void shutdown();
		// terminate thread asap
		void terminate();
	private:
		PrinterThread();
		void threadImpl();
		bool enoughPrinted() const;
		void print(PartialAssignment& pa);
	private:
		PrinterThreadCallback* callback_;
		const ProgramInterface* program_;
		AnswerSetPrinterBase* printer_;
		const size_t requestedAnswerSets_;
		size_t printedAnswerSets_;
		const unsigned delay_;

		volatile bool shutdown_;
		volatile bool terminate_;
	};
}

#endif
