/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_RANDOM_HEURISTIC_H
#define LIBNOMORE_RANDOM_HEURISTIC_H
#include <static_heuristic.h>
#include <dynamic_heuristic.h>
#include <functional>
namespace NS_NOMORE {

//! Heuristic-Strategy that emulates random sorted rules.
/*! This class values all nodes (statically or dynamically) with a random value
 *  between 0 and 1023.
 *
 *  \note This Strategy may be used with either a Static- or a Dynamic-Heuristic.
 *  The Static-version is called StaticRandom. 
 *  The Dynamic-version is DynamicRandom.
 *  \see DynamicRandom
 *  \see StaticRandom
 *  \see StaticHeuristic
 *  \see DynamicHeuristic
 */
class RandomStrat {
public:
  typedef long ValueType; 
  typedef std::greater<ValueType> ComparatorType;
  struct Evaluate {
    ValueType operator()(Node* n) const;
  };  

  typedef Evaluate EvaluatorType;
};

//! Heuristic-Strategy that emulates random sorted atoms.
/*! This class values all head nodes (statically or dynamically) with a random value
 *  between 0 and 1023.
 *
 *  \note This Strategy may be used with either a Static- or a Dynamic-Heuristic.
 *  The Static-version is called StaticRandom. 
 *  The Dynamic-version is DynamicRandom.
 *  \see DynamicRandom
 *  \see StaticRandom
 *  \see StaticHeuristic
 *  \see DynamicHeuristic
 */
class RandomHeadNodeStrat {
public:
  typedef long ValueType; 
  typedef std::greater<ValueType> ComparatorType;
  struct Evaluate {
    ValueType operator()(Node* n) const;
  };  

  typedef Evaluate EvaluatorType;
};

//! A static heuristic that uses RandomStrat as its strategy.
typedef StaticHeuristic<RandomStrat> StaticRandom;

//! A dynamic heuristic that uses RandomStrat as its strategy.
typedef DynamicHeuristic<RandomStrat> DynamicRandom;

//! A static heuristic that uses RandomStrat as its strategy.
typedef StaticHeuristic<RandomHeadNodeStrat> StaticRandomHeads;

//! A dynamic heuristic that uses RandomStrat as its strategy.
typedef DynamicHeuristic<RandomHeadNodeStrat> DynamicRandomHeads;

}
#endif
