/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <stack.h>
#include <graph.h>

namespace NS_NOMORE {

BacktrackStack::BacktrackStack() {}

BacktrackStack::Branch::Branch(const Item& cp) : cp_(cp) {}

void BacktrackStack::Branch::restore(Graph& g) {
  while(!stack_.empty())  {
    Item item = stack_.top();
    stack_.pop();
    g.restore(*item.node_, item.color_);
  }
}


Node* BacktrackStack::Branch::restoreCp(Graph& g) {
  restore(g);
  g.restore(*cp_.node_, cp_.color_);
  return cp_.node_;
}
}
