/*	$Id: worker.h 1748 2005-05-10 14:10:45Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef WORKER_H
#define WORKER_H

#include <memory>
#include <portablethreads/thread.h>

namespace Platypus
{
	class WorkerCallbackAdaptor;
	class Foreman;
	class ForemanAssistant;
	class Kernel;
	class Worker : public PortableThreads::PThread
	{
	public:
		~Worker();
		Worker(int id, Foreman& df, ForemanAssistant& tf);
		void setup();
	private:
		Worker();
		void threadImpl();		
	private:
		std::auto_ptr<WorkerCallbackAdaptor> callback_;
		std::auto_ptr<Kernel> kernel_;
	};
}

#endif
