/*	$Id: types_factory.h 2058 2005-06-29 07:52:37Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef TYPES_FACTORY_H
#define TYPES_FACTORY_H

#include <string>
#include <program_options/program_options_fwd.h>
#include <platypus/factories/program_factory.h>
#include <platypus/factories/expander_factory.h>
#include <platypus/factories/core_factory.h>
#include <platypus/factories/distribution_factory.h>
#include <platypus/factories/delegatable_choice_policy_factory.h>
#include <platypus/factories/probing_policy_factory.h>
#include <platypus/factories/choice_policy_factory.h>

namespace Platypus
{
	class PlatypusTypesFactory
	{
	public:
		static PlatypusTypesFactory& instance();
		std::string usage() const;
		void loadModules(int& argc, char** argv);
		inline ExpanderFactory& expanderFactory()
		{
			return ExpanderFactory::instance();
		}
		inline const ExpanderFactory& expanderFactory() const
		{
			return ExpanderFactory::instance();
		}
		inline ProgramFactory& programFactory()
		{
			return ProgramFactory::instance();
		}
		inline const ProgramFactory& programFactory() const
		{
			return ProgramFactory::instance();
		}
		inline DCPolicyFactory& delegatableChoicePolicyFactory()
		{
			return DCPolicyFactory::instance();
		}
		inline const DCPolicyFactory& delegatableChoicePolicyFactory() const
		{
			return DCPolicyFactory::instance();
		}
		inline CoreFactory& coreFactory()
		{
			return CoreFactory::instance();
		}
		inline const CoreFactory& coreFactory() const
		{
			return CoreFactory::instance();
		}
		inline DistributionFactory& distributionFactory()
		{
			return DistributionFactory::instance();
		}
		inline const DistributionFactory& distributionFactory() const
		{
			return DistributionFactory::instance();
		}
		inline ProbingPolicyFactory& probingPolicyFactory()
		{
			return ProbingPolicyFactory::instance();
		}
		inline const ProbingPolicyFactory& probingPolicyFactory() const
		{
			return ProbingPolicyFactory::instance();
		}
		inline ChoicePolicyFactory& choicePolicyFactory()
		{
			return ChoicePolicyFactory::instance();
		}
		inline const ChoicePolicyFactory& choicePolicyFactory() const
		{
			return ChoicePolicyFactory::instance();
		}
	private:
		PlatypusTypesFactory();
		static void populateProgramOptions();
	private:
		static std::auto_ptr<ProgramOptions::OptionGroup> options_;
		static std::auto_ptr<ProgramOptions::OptionValues> values_;
	};
}

#endif
