/*	$Id: choice.h 2069 2005-06-29 09:54:14Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_CHOICE_H
#define PLATYPUS_CHOICE_H

#include <iosfwd>
#include <vector>

namespace Platypus
{
	typedef unsigned long ChoiceId;
	typedef std::vector<ChoiceId> PossibleChoices;

	class Choice
    {
    public:
		Choice(ChoiceId id, bool positive);
		inline ChoiceId id() const { return id_; }
		inline bool isPositive() const { return positive_; }
		inline void toggle() { positive_ = !positive_; }
	private:
		Choice();
	private:
		ChoiceId id_;
		bool positive_;
    };

	inline bool operator==(const Choice& lhs, const Choice& rhs)
	{
		return lhs.id() == rhs.id() && lhs.isPositive() == rhs.isPositive();
	}
	
	inline bool operator!=(const Choice& lhs, const Choice& rhs)
	{
		return !(lhs == rhs);
	} 
	
	class Branch
	{
	public:
		typedef std::vector<Choice> Path;
		typedef Path::size_type size_type;
		typedef Choice& reference;
		typedef const Choice& const_reference;
		typedef Choice value_type;
		typedef Path::iterator iterator;
		typedef Path::const_iterator const_iterator;
		inline bool empty() const { return path_.empty(); }
		inline size_type size() const { return path_.size(); }
		inline reference operator[](size_type index)
		{
			return path_[index];
		}
		inline const_reference operator[](size_type index) const
		{
			return path_[index];
		}
		inline iterator begin() 
		{
			return path_.begin();
		}
		inline const_iterator begin() const
		{
			return path_.begin();
		}
		inline iterator end() 
		{
			return path_.end();
		}
		inline const_iterator end() const
		{
			return path_.end();
		}
		inline void push_back(const_reference c)
		{
			path_.push_back(c);
		}
		inline void pop_back()
		{
			path_.pop_back();
		}
		inline reference back() 
		{
			return path_.back();
		}
		inline const_reference back() const
		{
			return path_.back();
		}
		inline void reserve(size_type n)
		{
			path_.reserve(n);
		}
		inline void swap(Branch& other)
		{
			path_.swap(other.path_);
		}
		inline const Path& path() const { return path_; }
		inline void clear()
		{
			path_.clear();
		}
	private:
		Path path_;
	};

	inline bool operator==(const Branch& lhs, const Branch& rhs)
	{
		return lhs.path() == rhs.path();
	}

	inline bool operator!=(const Branch& lhs, const Branch& rhs)
	{
		return !(lhs == rhs);
	}

	typedef Branch DelegatableChoice;

	// allow to print Choice/DC to ostream
	std::ostream& operator<<(std::ostream& os, const Choice& choice);
	std::ostream& operator<<(std::ostream& os, const Branch& dc);
}



#endif
