/*	$Id: expander.cpp 2058 2005-06-29 07:52:37Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cassert>
#include <platypus/types/expander_strategies.h>
#include <platypus/types/choice_policy.h>
#include <platypus/types/expander.h>

namespace Platypus
{
	Expander::~Expander()
	{}

	Expander::Expander()
		:	choicePolicy_(0)
	{}
	// Capability casts, then set proper strategy object
	void Expander::createChoiceStrategy(Expander* expander)
	{
		assert(expander);
		if(dynamic_cast<Choosable*>(expander))
			chooseStrategy_.reset(new NativeChooser(*expander));
		else
			chooseStrategy_.reset(new ManualChooser(*expander));
	}
	void Expander::createBracktrackStrategy(Expander* expander, const Branch& dc)
	{
		assert(expander);
		if(dynamic_cast<Backtrackable*>(expander))
			backtrackStrategy_.reset(new NativeBacktracker(*expander));
		else
			backtrackStrategy_.reset(new ManualBacktracker(*expander, dc));

	}
	void Expander::createStrategy(Expander* expander, const Branch& dc)
	{
		createChoiceStrategy(expander);		
		createBracktrackStrategy(expander, dc);
	}
	void Expander::expand(const Choice& choice)
	{
		assert(backtrackStrategy_.get() && "forgot to call Expander::createStrategy");
		backtrackStrategy_->expand(choice);
	}

	void Expander::backtrackTo(const Choice& choice)
	{
		assert(backtrackStrategy_.get() && "forgot to call Expander::createStrategy");
		backtrackStrategy_->backtrack(choice);
	}
	
	void Expander::reinitialize(const Branch& dc)
	{
		assert(backtrackStrategy_.get() && "forgot to call Expander::createStrategy");
		assert(chooseStrategy_.get() && "forgot to call Expander::createStrategy");
		backtrackStrategy_->reinitialize(dc);
	}

	Choice Expander::getChoice()
	{
		assert(chooseStrategy_.get() && "forgot to call Expander::createStrategy");
		return chooseStrategy_->choose();
	}
	void Expander::setManualChoice(bool yes)
	{
		if(yes)
		{
			if(!chooseStrategy_.get() || chooseStrategy_->nativeChooser())
				chooseStrategy_.reset(new ManualChooser(*this));
		}
		else
		{
			if(!chooseStrategy_.get() || !chooseStrategy_->nativeChooser())
				createChoiceStrategy(this);
		}
		chooseStrategy_->setPolicy(*choicePolicy_);
	}
	void Expander::setChoicePolicy(const ChoicePolicy::PolicyBase& policy)
	{
		assert(chooseStrategy_.get() && "forgot to call Expander::createStrategy");
		choicePolicy_.reset(policy.clone());
		chooseStrategy_->setPolicy(*choicePolicy_);
	}
	void Expander::setChoicePolicy(ChoicePolicy::PolicyBase* policy)
	{
		assert(chooseStrategy_.get() && "forgot to call Expander::createStrategy");
		choicePolicy_.reset(policy);
		chooseStrategy_->setPolicy(*choicePolicy_);
	}
	
	bool Expander::nativeChooser() const
	{
		assert(chooseStrategy_.get() && "forgot to call Expander::createStrategy");
		return chooseStrategy_->nativeChooser();
	}
	bool Expander::nativeBacktracker() const
	{
		assert(backtrackStrategy_.get() && "forgot to call Expander::createStrategy");
		return backtrackStrategy_->nativeBacktracker();
	}
}
