/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NATIVE_DCAS_POINTER_CAS_H
#define NATIVE_DCAS_POINTER_CAS_H

#define PT_POINTER_CAS_INCLUDED

PT_NAMESPACE_BEGIN

namespace PTPrivate
{
	class PointerCAS
	{
	public:
		typedef PTSizeToType_<sizeof(pt_pointer_type)>::int_type int_t;
		typedef PTSizeToType_<2*sizeof(int_t)>::int_type large_int_t;
		typedef PTPrivate::token_t token_t;
	public:
		explicit
		PointerCAS(int_t v = 0)
			:	value_(0)
		{
			assign(v);
		}
		inline bool cas(int_t nv, const token_t& ov)
		{
			return pt_atomic_cas(
				&value_,
				multiplex(nv, ov.count()+1),
				multiplex(ov.value(), ov.count()));
		}
		inline token_t get() const
		{
			const large_int_t current = value_;
			return token_t(high(current), low(current));
		}
		inline void assign(int_t value)
		{
			value_ = multiplex(value, low(value_));
		}
	private:
		static inline int_t high(large_int_t large)
		{
			return static_cast<int_t>(large >> SHIFT);
		}
		static inline int_t low(large_int_t large)
		{
			return static_cast<int_t>(large);
		}
		static inline large_int_t multiplex(int_t value, int_t count)
		{
			large_int_t ret = value;
			ret <<= SHIFT;
			ret |= count;
			return ret;
		}
		PointerCAS(const PointerCAS&);
		PointerCAS operator=(const PointerCAS&);
	private:
		volatile large_int_t value_;

		static const unsigned SHIFT = (sizeof(int_t)<<3);
	};
}

typedef PTPrivate::PointerCAS PTPointerCAS;

PT_NAMESPACE_END

#endif
