/*  Copyright (c) September 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SPARC_32_V8_GCC_H
#define SPARC_32_V8_GCC_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif

#include <sys/time.h>

PT_NAMESPACE_BEGIN

typedef signed char int8;
typedef unsigned char uint8;
typedef short int16;
typedef unsigned short uint16;
typedef int int32;
typedef unsigned int uint32;
typedef long long int64;
typedef unsigned long long uint64;

// Assembler functions are straight from the linux kernel
// NOTE: Appearently the pre v8plus architectures don't have 
// even have simple cas (not to mention dcas)
// SPARC is a 32-bit CPU with 32-bit addressing!


inline int32 pt_atomic_set(volatile int32* mem, int32 val)
{
	__asm__ __volatile__("swap [%2], %0 \n\t"
		: "=&r" (val)
		: "0" (val), "r" (mem)
		: "memory");
	return val;
}

inline bool pt_atomic_set_lock(volatile uint8* lock)
{
	uint32 result;
	__asm__ __volatile__("ldstub [%1], %0 \n\t"
		: "=r" (result)
		: "r" (lock)
		: "memory");
	return result == 0;
}

inline void pt_atomic_clear_lock(volatile uint8* lock)
{
	__asm__ __volatile__("stb %%g0, [%0] \n\t" : : "r"(lock) : "memory");
}

inline void pt_barrier()
{
	__asm__ __volatile__("" : : : "memory");
}

// No tick counter support on Sparc 8
inline uint64 pt_seed()
{
	timeval tv;
	gettimeofday(&tv, 0);
	
	uint64 t = tv.tv_usec;
	t += tv.tv_sec*1000000;
	return t;
}


PT_NAMESPACE_END

#include <portablethreads/arch/arch-common.h>
#include <portablethreads/arch/manual-spinlock-pointer-cas.h>
#include <portablethreads/arch/manual-spinlock-atomic-number.h>

#endif
