/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/lookahead.h>
#include <node.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <heuristic.h>

namespace NS_NOMORE {

Lookahead::Lookahead(const std::string& name, Graph& grp) 
  : GraphOperator(name, grp)
  , operator_(0) 
  , ownsOperator_(true)
  , constraint_(0) {
}

Lookahead::Lookahead(const std::string& name, Graph& grp, Operator& op, const Constraint& con) 
  : GraphOperator(name, grp)
  , operator_(&op) 
  , ownsOperator_(false) 
  , constraint_(&con) {
}

Lookahead::Lookahead(const std::string& name, Graph& grp, Operator* op, const Constraint& con) 
  : GraphOperator(name, grp)
  , operator_(op) 
  , ownsOperator_(true) 
  , constraint_(&con) {
}

Lookahead::~Lookahead() {
  if (ownsOperator_)
    delete operator_;
}

void Lookahead::setPropagationOperator(Operator& op) {
  if (ownsOperator_ && operator_ != &op)
    delete operator_;
  operator_ = &op;
  ownsOperator_ = false;
}

void Lookahead::setPropagationOperator(Operator* op) {
  if (ownsOperator_ && operator_ != op)
    delete operator_;
  operator_ = op;
  ownsOperator_ = true;
}

void Lookahead::setPropagationOperator(Operator* op, bool takeOverOwnership) {
  if (takeOverOwnership)
    setPropagationOperator(op);
  else
    setPropagationOperator(*op);
}

bool Lookahead::checkColor(Node &node, Color::ColorValue color) {
  struct Cleaner {
  public:
    Cleaner(Graph& grp) : grp_(&grp) {
    }

    ~Cleaner() {
      grp_->restoreChoicePoint();
    }

  private:
    Graph *grp_;
  } cleaner(getGraph());
    
  // color node as choice point -> a new stack is used
  getGraph().colorChoicePoint(node, color, Color::plus);
  return (*operator_)();
}

bool Lookahead::color(Node &node, Color::ColorValue color) {
  getGraph().colorChoicePointStable(node, color);
  return (*operator_)();
}

bool Lookahead::execute() {
  assert(constraint_ != 0);

  LookaheadExecution e(ActivityState::started);
  getGraph().getEventManager().dispatch(e);

  return true;
}

void Lookahead::postExecute() {
  LookaheadExecution e(ActivityState::finished);
  getGraph().getEventManager().dispatch(e);
}

Operator& Lookahead::getPropagationOperator() {
  return *operator_;
}

const Operator& Lookahead::getPropagationOperator() const {
  return *operator_;
}

}
