#ifndef NOMORE_PROGRAM_H_INCLUDED
#define NOMORE_PROGRAM_H_INCLUDED

#include <platypus/types/program.h>
namespace Platypus { namespace Nomore { 
  
// hide implementation to keep platypus independent of nomore dependencies.
class ProgramImpl;

/*!
 * A Nomore Program reads lparse from an istream and creates
 * a corresponding body-head graph.
 * 
 */
class Program : public Platypus::Program
{
public:
    typedef Platypus::Program BaseType;

    Program();
    ~Program();

    // base interface
    using BaseType::setup;

    void setup(std::istream& is);
    std::string idToName(AtomId id) const;
    const CollectionType& atoms() const;

    size_t numberOfAtoms() const;
    size_t numberOfRules() const;

    bool hasDisplayName(AtomId id) const;

    const ProgramImpl* getImplementation() const {
        return impl_; 
    }
private:
    // nomore programs are neither copyable nor assignable
    Program(const Program&);
    Program& operator=(const Program&);

    ProgramImpl* impl_;
};

} }

#endif
