/*  Copyright (c) October 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FOUR_BYTE_POINTER_TO_INT_COMPRESSION_H
#define FOUR_BYTE_POINTER_TO_INT_COMPRESSION_H

#include <cassert>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			template<typename T, typename int_t, unsigned ALIGNMENT_BITS>
			inline int_t pt_inflate_pointer(T* p)
			{
				assert((reinterpret_cast<int_t>(p) & ((static_cast<int_t>(1) << ALIGNMENT_BITS)-1)) == static_cast<int_t>(0));
				assert(sizeof(int_t) >= sizeof(T*));

				return reinterpret_cast<int_t>(p) >> ALIGNMENT_BITS;
			}

			template<typename T, typename int_t, unsigned ALIGNMENT_BITS>
			inline T* pt_deflate_pointer(int_t i)
			{
				return reinterpret_cast<T*>(i << ALIGNMENT_BITS);
			}
		}
	}
}

#endif
