/*  Copyright (c) October 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cassert>
#include <cstdio>
#include <portablethreads/barrier.h>

using namespace std;

namespace PortableThreads
{
	PTBarrier::~PTBarrier()
	{}
	PTBarrier::PTBarrier(unsigned threads)
		:	size_(threads)
		,	counter_(threads)
	{
		assert(threads);
	}
	bool PTBarrier::wait()
	{
		const int_type current = --counter_;
		if(current >= 0)
		{
			if(current == 0)
			{
				//std::printf("Unlocking waiters\n");
				for(int_type i = 1; i < size_; ++i)
				{
					sem_.up();
				}
				counter_ = size_;
			}
			else
			{
				//std::printf("Blocking on sem\n");
				sem_.down();
			}
			return true;
		}
		else
		{
			//std::printf("Falling through, counter value: %d\n", (int)current);
		}
		return false;	
	}	
	
}



