



#if 0


/*
 *	Copyright (c) Januar 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  Einige Beispiele zur Benutzung der Thread-Klassen
 *
 */

#ifdef _MSC_VER
	#pragma warning(disable:4786)
	#pragma warning(disable:4503)
#endif

#include <iostream>
#include <fstream>
#include <string>
#include <cassert>
#include <deque>
#include <list>
#include <ctime>
#include <cstdlib>
#include <cstdio>
#include <set>
#include <portablethreads/mutex.h>
#include <portablethreads/condition.h>
#include <portablethreads/thread.h>
#include <portablethreads/tsallocator.h>
#include <portablethreads/message_queue.h>
#include <portablethreads/utility.h>
#include <portablethreads/lock_free.h>
#ifdef _MSC_VER
	#include <crtdbg.h>
#endif

using namespace std;
using namespace PortableThreads;






/*****************************************************************************/

// In diesem Ping-Pong Beispiel wird ein Monitor zur Synchronisation genutzt. 
// Der Vorteil des Monitors gegenber einer Mutex ist das der Monitor potentiell
// performanter ist wenn nur ein Thread gleichzeitig versucht darauf zuzugreifen.
// Bei einer Mutex muss jedes mal der Speicherbus gesperrt werden - beim Monitor
// wird durch atomares dekrementieren eines Zhlers sichergestellt das sich jeweils
// nur ein Thread im Monitor befindet. Versucht ein weiterer Thread den Monitor zu
// betreten, so muss er warten, bis der aktive Thread den Monitor verlsst und dies
// ggf. wartenden Threads signalisiert.


namespace beispiel_8
{
	class PingPong : public PThread
	{
	public:
		PingPong(int id, PMonitor& monitor, volatile bool& ping)
			:	id_(id)
			,	monitor_(monitor)
			,	ping_(ping)
		{}
		void threadMain()
		{
			for(int i = 0; i < 10; ++i)
			{
				// Versuche den Monitor zu betreten. Falls bereits ein Thread
				// im Monitor ist, warten wir blockierend.
				monitor_.enter();
				cout << id_ << " " << (ping_ ? "ping" : "pong") << endl;
				ping_ = !ping_;
				monitor_.leave();
			}
		}
	private:
		const int id_;
		PMonitor& monitor_;
		volatile bool& ping_;
	};
}

void beispiel8()
{
	cout << "Ping-Pong Beispiel mit 2 Threads die durch einen Monitor synchronisiert werden. ";
	cout << "Press enter to start" << endl;
	cin.get();

	using namespace beispiel_8;

	PMonitor monitor;
	volatile bool ping = true;

	// Drei bzw. zwei oder ein Threads versuchen konkurrierend dPing bzw. Pong auszugeben.
	PingPong p1(1, monitor, ping), p2(2, monitor, ping), p3(3, monitor, ping);
	
	p3.run();
	p2.run();
	p1.run();

	p1.join();
	p2.join();
	p3.join();


	p2.run();
	p1.run();

	p1.join();
	p2.join();

	p1.run();

	p1.join();
}


namespace beispiel_12
{

	typedef vector<unsigned long> ShortList;
	typedef pair<size_t, ShortList > Element;
	typedef PLockFreeQueue<Element> Queue;
	
	class Reader : public PThread
	{
	public:
		Reader(int id, Queue& queue)
			:	id_(id)
			,	shutdown_(false)
			,	queue_(queue)
		{}

		void threadMain()
		{
			Element e;			
			while(!shutdown_)
			{
				bool didRemove = queue_.popFront(e);
				if(didRemove)
				{
					int ok = e.first == e.second.size();
					if(ok)
					{
						for(size_t i = 0; i < e.second.size(); ++i)
						{
							assert(e.second[i] == e.first);
						}
					}
					assert(ok);
				}
				else
					give();
			}
			std::printf("R %d done\n", id_);
		}
		void shutdown() volatile { shutdown_ = true; }
	private:
		const int id_;
		volatile bool shutdown_;
		Queue& queue_;
	};

	class Writer : public PThread
	{
	public:
		Writer(int id, Queue& queue, int runs)
			:	id_(id)
			,	queue_(queue)
			,	runs_(runs)
		{}
		void threadMain()
		{
			PRandom r(time(0));
			for(int i = 0; i < runs_; ++i)
			{
				unsigned long n = r.urand() % 100;
				Queue::value_type vt = make_pair(n, ShortList(n, n));
				queue_.pushBack(vt);
				if(i % 5 == 0)
					pt_milli_sleep(50);
			}
		}
	private:
		const int id_;
		Queue& queue_;
		int runs_;
	};
}

/*****************************************************************************/

// Testcode (Reader-Writer) fr Lock-Free Datenstrukturen. Es werden die Queue 
// und der Stack getestet mit jeweils zwei Readern und Writern. 
// Jede Datenstruktur wird einmal mit aktivierten Speichermanagement (fat,
// interner Speicher wird wiederverwendet)
// und einmal ohne (lean, jedes Einfgen zieht eine heap-Allocation nach sich)
// getest.

void beispiel12()
{
	using namespace beispiel_12;
	// queue lean
	if(1)
	{
		Queue queue(true);
		Reader r1(1, queue), r2(2, queue), r3(3, queue), r4(4, queue);

		r1.run();
		r2.run();
		r3.run();
		r4.run();

		Writer w1(1, queue, 20), w2(2, queue, 30), w3(3, queue, 30), w4(4, queue, 20);
		w1.run();
		w2.run();
		w3.run();
		w4.run();

		w1.join();
		w2.join();
		w3.join();
		w4.join();

		std::printf("Writers joined\n");
		r1.shutdown();
		r2.shutdown();
		r3.shutdown();
		r4.shutdown();
		std::printf("Signaled readers shutdown\n");
		r1.join();
		std::printf("R1 joined\n");
		r2.join();
		std::printf("R2 joined\n");
		r3.join();
		std::printf("R3 joined\n");
		r4.join();
		std::printf("R4 joined\n");
		std::printf("Forcing queue d'tor\n");
	}
	std::printf("Queue d'tor went ok\n");

	// queue fat
	if(1)
	{
		Queue queue;
		Reader r1(1, queue), r2(2, queue), r3(3, queue), r4(4, queue);

		r1.run();
		r2.run();
		r3.run();
		r4.run();

		Writer w1(1, queue, 20), w2(2, queue, 30), w3(3, queue, 30), w4(4, queue, 20);
		w1.run();
		w2.run();
		w3.run();
		w4.run();

		w1.join();
		w2.join();
		w3.join();
		w4.join();

		std::printf("Writers joined\n");
		r1.shutdown();
		r2.shutdown();
		r3.shutdown();
		r4.shutdown();
		std::printf("Signaled readers shutdown\n");
		r1.join();
		std::printf("R1 joined\n");
		r2.join();
		std::printf("R2 joined\n");
		r3.join();
		std::printf("R3 joined\n");
		r4.join();
		std::printf("R4 joined\n");
		std::printf("Forcing queue d'tor\n");
	}
	std::printf("Queue d'tor went ok\n");
	
	
}

/*****************************************************************************/

// Testcode fr PAtomicNumber. Der Code soll sicherstellen, dass atomare
// Vernderungen an der Zahl auch wirklich atomar sind.


namespace beispiel_13
{
	class AtomicBomber : public PThread
	{
	public:
		AtomicBomber(PAtomicNumber& n, int runs, bool up)
			:	n_(n)
			,	runs_(runs)
			,	up_(up)
		{}
		void threadMain()
		{
			PRandom r(time(0));
			for(int i = 0; i < runs_; ++i)
			{
				uint64 n = r.urand();
				if(up_)
				{
					n_.inc(2*n);
					n_.dec(2*n-1);
				}
				else
				{
					n_.dec(2*n);
					n_.inc(2*n-1);
				}
			}
		}
	private:
		PAtomicNumber& n_;
		const int runs_;
		bool up_;
	};

}


void beispiel13()
{
	using namespace beispiel_13;

	PAtomicNumber n;
	AtomicBomber b1(n, 10000000, true), b2(n, 5000000, true), b3(n, 5000000, false), b4(n, 10000000, false);

	b1.run();
	b2.run();
	b3.run();
	b4.run();

	b1.join();
	b2.join();
	b3.join();
	b4.join();

	if(n.get() != 0)
	{
		cout << n.get() << endl;
	}
	assert(n.get() == 0);	
}
/*****************************************************************************/

// Rudimentrer sanity-check fr PAtomicNumber

void beispiel11()
{
	PAtomicNumber n;
	const PAtomicNumber::int_type shouldBe43 = n.inc(43);
	cout << "Return value should be 43, is: " << shouldBe43 << endl;
	cout << "n should be 43, is: " << n.get() << endl;
	assert(shouldBe43 == 43);
	assert(n.get() == 43);
	const PAtomicNumber::int_type shouldBe42 = n.dec(1);
	cout << "Return value should be 42, is: " << shouldBe42 << endl;
	cout << "n should be 42, is: " << n.get() << endl;
	assert(shouldBe42 == 42);
	assert(n.get() == 42);


	n = 0;
	bool ok = n.swap(-1, 0);
	cout << "Swap should succeed, did: " << ok << endl;
	assert(ok);
	ok = n.swap(-2, 0);
	cout << "Swap should NOT succeed, did: " << ok << endl;
	ok = n.swap(-1, -1);
	cout << "Swap should succeed, did: " << ok << endl;
	assert(ok);

	if(1)
	{
		int64 n = 0;
		bool ok = pt_atomic_cas(&n, -1, 0);
		cout << "Swap should succeed, did: " << ok << endl;
		assert(ok);
		assert(n == -1);
		
		ok = pt_atomic_cas(&n, -2, 0);
		cout << "Swap should NOT succeed, did: " << ok << endl;
		assert(!ok);
		assert(n == -1);
		ok = pt_atomic_cas(&n, -1, -1);
		cout << "Swap should succeed, did: " << ok << endl;
		assert(ok);
		assert(n == -1);
	}
}

namespace xorQueue
{
	template<typename T, typename A = std::allocator<T> >
	class XORQueue
	{
	public:
		typedef T& reference;
		typedef const T& const_reference;
	private:
		typedef PortableThreads::LockFree::Private::PTPointerCAS PTPointerCAS;
		typedef PortableThreads::LockFree::Private::token_t token_t;
		typedef PortableThreads::LockFree::Private::SingleLinkedNode<T> Node;
	public:
		XORQueue()
			:	head_(0)
			,	tail_(0)
			,	special_(0)
		{}
		bool pushFront(const_reference r)
		{
			Node* node = new Node;
			node->construct(r);

			
			token_t h, t, n;
			int64 s;
			bool done = false;
			while(!done)
			{
				h = head_.get();
				t = tail_.get();
				s = special_;
				node->next(h.value());
				if(tag(s) == 0)
				{
					if(h.value() == 0 && t.value() == 0) // empty
					{
						int64 new_s = multiplex(node, 1, s);
						if(LockFree::Private::pt_atomic_cas(&special_, new_s, s))
						{
							cout << "we\n";
							s = new_s;
							done = true;
						}
						
					}
					else
					{
						if(h.value() != 0 && t.value() != 0)
						{
							n = reinterpret_cast<Node*>(h.value())->next();
							int64 new_s = multiplex(node, 3, s);
							if(LockFree::Private::pt_atomic_cas(&special_, new_s, s))
							{
								cout << "w+1\n";
								s = new_s;
								done = true;
							}
							
						}
					}
				}
				dispatch(s);
			}
			return true;
		}
		bool popFront(reference r)
		{
			token_t h, t, n;
			int64 s;
			bool done = false;
			while(!done)
			{
				h = head_.get();
				t = tail_.get();
				s = special_;

				if(h.value() == 0 && t.value() == 0) // empty
					return false;

				if(tag(s) == 0)
				{
					if(h.value() == t.value()) // single element
					{
						int64 new_s = multiplex(0, 2, s);
						if(LockFree::Private::pt_atomic_cas(&special_, new_s, s))
						{
							cout << "re\n";
							s = new_s;
							done = true;
						}
					}
					else
					{
						n = reinterpret_cast<Node*>(h.value())->next();
						if(!n.value()) 
							continue;
						int64 new_s = multiplex(reinterpret_cast<Node*>(n.value()), 5, s);
						if(LockFree::Private::pt_atomic_cas(&special_, new_s, s))
						{
							cout << "r-1\n";
							s = new_s;
							done = true;
						}
					}
					
				}
				else
				{
					//cout << "unstable\n";
				}
				dispatch(s);
			}
			assert(h.value());
			r = reinterpret_cast<Node*>(h.value())->data();
			return true;
		}
	private:
		void dispatch(int64 s)
		{
			// STACKABHNGIG!!!!!!!!!!!
			if(s != special_)
				return;
			if(tag(s) == static_cast<int64>(1))
			{
				// push into empty queue
				if(s != special_)
					return;
				head_.cas(reinterpret_cast<PTPointerCAS::int_t>(pointer(s)), head_.get());
				if(s != special_)
					return;
				tail_.cas(reinterpret_cast<PTPointerCAS::int_t>(pointer(s)), t);
			}
			else if(tag(s) == static_cast<int64>(2))
			{
				// pop from queue with one element
				if(s != special_)
					return;
				head_.cas(0, h);
				if(s != special_)
					return;
				tail_.cas(0, t);
			}
			
			else if(tag(s) == static_cast<int64>(3))
			{
				// pushfront, one in queue
				
				Node* newhead = pointer(s);
				assert(newhead);
				h = head_.get();
				Node* oldhead = reinterpret_cast<Node*>(h.value());
				if(oldhead == reinterpret_cast<Node*>(newhead->next().value()))
				{
					token_t x = oldhead->next();

					if(special_ == s)
						oldhead->cas(x.value() ^ reinterpret_cast<PTPointerCAS::int_t>(newhead), x);
				}
				head_.cas(reinterpret_cast<PTPointerCAS::int_t>(newhead), h);
			}
			else if(tag(s) == static_cast<int64>(5))
			{
				// popfront
				Node* newhead = pointer(s);
				assert(newhead);

				Node* oldhead = reinterpret_cast<Node*>(h.value());
				Node* newhead = reinterpret_cast<Node*>(n.value());
				token_t x = newhead->next();
				if(s != special_)
					return;
				newhead->cas(h.value() ^ x.value(), x);
				
				if(s != special_)
					return;
				head_.cas(reinterpret_cast<PTPointerCAS::int_t>(newhead), h);
			}
			
			int64 new_s = multiplex(0, 0, s);
			LockFree::Private::pt_atomic_cas(&special_, new_s, s);
		}
		static int64 multiplex(Node* p, int64 t, int64 ov)
		{
			int64 nv = reinterpret_cast<int64>(p) << 32;
			assert(t >= 0);
			assert(t <= 7);
			nv ^= (t << 29);
			int64 oldcount = ov & ((static_cast<int64>(1) << 29)-1);
			if(++oldcount <= (static_cast<int64>(1) << 29))
				nv ^= oldcount;

			assert(pointer(nv) == p);
			assert(tag(nv) == t);
			return nv;
		}
		static inline int64 tag(int64 s)
		{
			return (s >> 29) & static_cast<int64>(7);
		}
		static inline Node* pointer(int64 s)
		{
			return reinterpret_cast<Node*>(s >> 32);
		}
	private:
		PTPointerCAS head_, tail_;
		volatile int64 special_;
	};

	typedef XORQueue<int> IntQueue;

	class Writer : public PThread
	{
	public:
		Writer(PTBarrier& b, IntQueue& q, unsigned count)
			:	barrier_(&b)
			,	queue_(&q)
			,	count_(count)
		{}
	private:
		void threadMain()
		{
			barrier_->wait();
			for(unsigned i = 0; i < count_;)
			{
				if(queue_->pushFront(i))
				{ 
					++i;
				}
				else
				{
					cout << "w push failed\n";
				}
			}
		}
	private:
		PTBarrier* barrier_;
		IntQueue* queue_;
		unsigned count_;
	};

	class Reader : public PThread
	{
	public:
		Reader(PTBarrier& b, IntQueue& q, unsigned count)
			:	barrier_(&b)
			,	queue_(&q)
			,	count_(count)
		{}
	private:
		void threadMain()
		{
			barrier_->wait();
			for(unsigned i = 0; i < count_;)
			{
				int x = 0;
				bool ok = queue_->popFront(x);
				if(ok)
				{
					++i;
					assert(x < count_);
				}
				else
				{
					cout << "r pop failed\n";
				}
				
			}
		}
	private:
		PTBarrier* barrier_;
		IntQueue* queue_;
		unsigned count_;
	};
}

void xorqueue()
{
	int x = 0;
	xorQueue::XORQueue<int> d;
	
	d.pushFront(1);
	d.pushFront(2);
	d.pushFront(3);
	d.popFront(x);
	cout << x << "\n";
	d.popFront(x);
	cout << x << "\n";
	d.popFront(x);
	cout << x << endl;
	

	xorQueue::XORQueue<int> q;
	unsigned threads = 4;
	unsigned count = 1000;
	PTBarrier b(2*threads + 1);
	vector<xorQueue::Writer*> writer(threads);
	vector<xorQueue::Reader*> reader(threads);

	for(unsigned i = 0; i < threads; ++i)
	{
		writer.push_back(new xorQueue::Writer(b, q, count));
		writer.back()->run();
		reader.push_back(new xorQueue::Reader(b, q, count));
		reader.back()->run();
	}
	

	b.wait();

	for(unsigned i = 0; i < threads; ++i)
	{
		writer.back()->join();
		delete writer.back();
		writer.pop_back();
		reader.back()->join();
		delete reader.back();
		reader.pop_back();
	}
	
	bool ok;
	int y;
	ok = q.popFront(y);
	cout << "Should fail (0 = good): " << ok << endl;

}

#endif
