#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/thread.h>
#include <portablethreads/time.h>


using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

namespace
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			CPPUNIT_ASSERT(false && "no exception excepted");
		}
	};
	class Thread0 : public ThreadBase
	{
		void threadMain()
		{
			CPPUNIT_ASSERT_EQUAL(PThread::DEADLOCK, join());
		}
	};
	class Thread1 : public ThreadBase
	{
	public:
		Thread1(volatile bool& flag)
			:	flag_(&flag)
		{}
	private:	
		void threadMain()
		{
			*flag_ = true;
		}
	private:
		volatile bool* flag_;
	};

	class Thread2 : public ThreadBase
	{
	public:
		Thread2(volatile bool& flag)
			:	flag_(&flag)
		{}
	private:	
		void threadMain()
		{
			while(!*flag_)
			{
				give();
			}
		}
	private:
		volatile bool* flag_;
	};
	class Thread3 : public ThreadSilentBase
	{
	public:
		Thread3(volatile bool& flag)
			:	flag_(&flag)
		{}
	private:	
		void threadMain()
		{
			throw 1;
		}
		void unexpectedException() throw()
		{
			*flag_ = true;
		}
	private:
		volatile bool* flag_;
	};
	class Thread4 : public ThreadSilentBase
	{
		void threadMain()
		{
			throw 1;
		}
	};
	class Thread5 : public ThreadBase
	{
	public:
		Thread5(volatile bool& flag)
			:	flag_(&flag)
		{}
	private:	
		void threadMain()
		{
			while(!*flag_)
			{
				give();
			}
			pt_milli_sleep(100);
			delete this;
		}
	private:
		volatile bool* flag_;
	};
}

class ThreadTest : public CppUnit::TestFixture
{
public:
	void testJoin()
	{
		PThread::thread_id_type id;
		{
			Thread0 t;
			id = t.id();
			CPPUNIT_ASSERT_EQUAL(PThread::NOT_RUNNING, t.join());
			CPPUNIT_ASSERT_EQUAL(PThread::OK, t.run());
			int ret =  t.join();
			CPPUNIT_ASSERT(PThread::OK == ret || PThread::NOT_RUNNING == ret);
			CPPUNIT_ASSERT_EQUAL(PThread::NOT_RUNNING, t.join());
		}
		CPPUNIT_ASSERT_EQUAL(PThread::DESTROYED, PThread::poll(id));
	}
	void testRun()
	{
		volatile bool f = false;
		volatile bool check = true;
		Thread1 t(f);
		t.run();
		t.join();

		CPPUNIT_ASSERT_EQUAL(check, f);
	}
	void testTryStartWhileRunning()
	{
		volatile bool f = false;
		Thread2 t(f);
		t.run();
		CPPUNIT_ASSERT_EQUAL(PThread::ALREADY_RUNNING, t.run());
		f = true;
		t.join();
	}
	void testCaughtException()
	{
		volatile bool f = false;
		volatile bool check = true;
		Thread3 t(f);
		t.run();
		t.join();
		CPPUNIT_ASSERT_EQUAL(check, f);
		CPPUNIT_ASSERT_EQUAL(PThread::NOT_RUNNING, t.join());
	}
	void testUncaughtException()
	{
		Thread4 t;
		t.run();
		t.join();
		CPPUNIT_ASSERT_EQUAL(PThread::NOT_RUNNING, t.join());

	}
	void testSelfDeletingThread()
	{
		volatile bool f = false;
		Thread5* t = new Thread5(f);
		t->run();
		// There is a race condition here. The main thread must
		// call t->join() before the object deletes itself
		f = true;
		t->join();
	}
	CPPUNIT_TEST_SUITE( ThreadTest );
		CPPUNIT_TEST( testJoin );
		CPPUNIT_TEST( testRun );
		CPPUNIT_TEST( testTryStartWhileRunning );
		CPPUNIT_TEST( testCaughtException );
		CPPUNIT_TEST( testUncaughtException );
		CPPUNIT_TEST( testSelfDeletingThread );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ThreadTest );


