#ifndef UNIX_XPLIB_H
#define UNIX_XPLIB_H

#include <dlfcn.h>
#include <string>

const char* const XPLIB_DLL_EXTENSION = ".so";
class XPDLLLinker
{
public:
	~XPDLLLinker()
	{
		if(lib_)
			dlclose(lib_);
	}
	XPDLLLinker(const std::string& name, bool completepath = false)
		:	lib_(completepath	? dlopen(name.c_str(), RTLD_NOW | RTLD_LOCAL) 
								: dlopen((name + XPLIB_DLL_EXTENSION).c_str(), RTLD_NOW | RTLD_LOCAL))
	{
		if(!lib_)
		{
			throw XPDLLException(dlerror());
		}
	}
	inline void* reference(const std::string& name) const
	{
		return dlsym(lib_, name.c_str());
	}
	inline operator void*() const { return lib_; }
	inline void* release() 
	{
		void* temp = lib_; 
		lib_ = 0; 
		return temp;
	}
private:
	XPDLLLinker();
	XPDLLLinker(const XPDLLLinker&);
	XPDLLLinker& operator=(const XPDLLLinker&);
private:
	void* lib_;
};
template<class T>
class XPFunctionProxy
{
public:
	XPFunctionProxy(void* f = 0)
		:	function_((T)f)
	{}
	inline T function() const { return function_; }
	inline operator T() const { return  function_; }
	inline bool good() const { return function_ != 0; }
private:
	T function_;
};

#endif
