#ifndef NOMORE_EXPANDER_H_INCLUDED
#define NOMORE_EXPANDER_H_INCLUDED

#include <platypus/types/expander.h>

namespace Platypus { namespace Nomore {
    
class Expander 
    : public Platypus::Expander
    , public Backtrackable
    , public Choosable
{
public:
    Expander(const ProgramInterface& program, const DelegatableChoice& dc = DelegatableChoice());
    ~Expander();
    
    typedef Platypus::Expander BaseType;

    // returns true if the expander has unknown atoms
	bool hasUnknown() const;

	// returns true if the expander has detected a conflict
	bool hasConflict() const;

	// returns a PartialModel representation of the internal
	// partial model. 
	PartialAssignment partialAssignment() const;

	size_t unknownAtoms() const;
private:
    Expander(const Expander&);
    Expander& operator=(const Expander&);

    void strategyExpand(const Choice& choice);
	void strategyReinitialize(const DelegatableChoice&);
	void strategyBacktrackTo(const Choice&);
	Choice strategyGetChoice();
    PossibleChoices possibleChoices() const;

    // hide implementation to keep platypus independent of nomore dependencies.
    class Impl;
    Impl* impl_;
};

} }

#endif

