#ifdef _WIN32
#	ifndef WIN32_LEAN_AND_MEAN 
#		define WIN32_LEAN_AND_MEAN 
#endif
#	include <windows.h>
#else
#	include <sys/types.h>
#	include <sys/stat.h>
#	include <fcntl.h>
#endif

#include "directory.h"

bool directoryExists(const std::string& path)
{
#ifdef _WIN32
	DWORD attribs = ::GetFileAttributes(path.c_str());
	return attribs != 0xFFFFFFFF && (attribs & FILE_ATTRIBUTE_DIRECTORY);
#else
	struct stat info;
	return ::stat( path.c_str(), &info ) == 0 && S_ISDIR(info.st_mode);
#endif
}


