// ProgramOptions (Alpha-Version) (c) Benjamin Kaufmann 
// ProgramOptions is a scaled-down version of boost::program_options
// see: http://boost-sandbox.sourceforge.net/program_options/html/

#include "string_functions.h"

namespace StringFunctions
{
	std::vector<std::string > 
	explode(const std::string& separator, const std::string& str)
	{
		typedef std::string String;
		String::size_type len = separator.length();
		std::vector<String> result;
		if (len == 0)
		{
			result.push_back(str);
			return result;
		}
		
		String::size_type startPos = 0;
		String::size_type endPos = str.find(separator, startPos);
		while (endPos != String::npos)
		{
			if (endPos - startPos)
				result.push_back(String(str, startPos, endPos - startPos));
			
			startPos = endPos;
			if (startPos != String::npos)
				startPos += len;
			endPos = str.find(separator, startPos);
		}
		String::size_type strLen = str.length();
		if (startPos != String::npos)
		{
			result.push_back(String(str, startPos, String::npos));
		}
		return result;
	}

	bool splitHalf(	const std::string& str, 
				const std::string& seperator,
				std::string& leftSide,
				std::string& rightSide)
	{
		typedef std::string String;
		String::size_type sepPos = str.find(seperator);
		leftSide.assign(str, 0, sepPos);
		if (sepPos != String::npos)
		{
			rightSide.assign(str, sepPos + seperator.length(), String::npos);
			return true;
		}
		return false;
	}

}	// namespace StringFunctions

