// ProgramOptions (Alpha-Version) (c) Benjamin Kaufmann 
// ProgramOptions is a scaled-down version of boost::program_options
// see: http://boost-sandbox.sourceforge.net/program_options/html/

#ifndef VALUE_BASE_H_INCLUDED
#define VALUE_BASE_H_INCLUDED
#ifdef _MSC_VER
#pragma warning (disable : 4786)
#pragma warning (disable : 4503)
#endif
#include <string>
namespace ProgramOptions {
class ValueBase
{
protected:
	ValueBase();
public:
	virtual ~ValueBase() = 0;
	virtual bool isImplicit() const = 0;
	virtual bool applyDefault() = 0;
	virtual bool fromString(const std::string&) = 0;
	virtual std::string toString() const = 0;
};

}

#endif
