/*  Copyright (c) March 2006 Jean Gressmann (jsg@rz.uni-potsdam.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CAS_BASED_64_BIT_ATOMIC_ADD_H
#define CAS_BASED_64_BIT_ATOMIC_ADD_H

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			// prototype
			inline bool pt_atomic_cas(volatile int64* mem, int64 nv, int64 ov);

			// atomically adds value to counter and returns the result
			inline int64 pt_atomic_add(volatile int64* counter, int64 value)
			{
				int64 current;
				do { current = *counter; } while(!pt_atomic_cas(counter, current+value, current));
				return current + value;
			}
		}
	}
}


#endif
