/*  Copyright (c) March 2006 Jean Gressmann (jsg@rz.uni-potsdam.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef NATIVE_ATOMIC_ARITHMETIC_COMMON_H
#define NATIVE_ATOMIC_ARITHMETIC_COMMON_H

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			// prototypes
			inline int32 pt_atomic_add(volatile int32* counter, int32 value);
			inline int64 pt_atomic_add(volatile int64* counter, int64 value);

			inline int32 pt_atomic_sub(volatile int32* counter, int32 value)
			{
				return pt_atomic_add(counter, -value);
			}

			inline int32 pt_atomic_inc(volatile int32* counter)
			{
				return pt_atomic_add(counter, 1);
			}

			inline int32 pt_atomic_dec(volatile int32* counter)
			{
				return pt_atomic_add(counter, -1);
			}

			inline int64 pt_atomic_sub(volatile int64* counter, int64 value)
			{
				return pt_atomic_add(counter, -value);
			}

			inline int64 pt_atomic_inc(volatile int64* counter)
			{
				return pt_atomic_add(counter, 1);
			}

			inline int64 pt_atomic_dec(volatile int64* counter)
			{
				return pt_atomic_add(counter, -1);
			}			
		}
	}
}

#endif

