/*  Copyright (c) September 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SPARC_32_V8_GCC_H
#define SPARC_32_V8_GCC_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif

#include <portablethreads/arch/32-gcc.h>
#include <portablethreads/arch/no-tick-register.h>
#include <portablethreads/arch/sparc-v8-gcc-common.h>

namespace PortableThreads 
{
	// Assembler functions are straight from the linux kernel
	// NOTE: Appearently the pre v8plus architectures don't have 
	// even have simple cas (not to mention cas2)
	// SPARC is a 32-bit CPU with 32-bit addressing!

	namespace LockFree
	{
		namespace Private
		{
			inline void pt_mfence()
			{
				__asm__ __volatile__("stbar" : : : "memory");
			}

			const unsigned HARDWARE_POINTER_BITS = 32;
			const unsigned ALIGNMENT_BITS = 2;
		}
	}
}

#include <portablethreads/arch/arch-common.h>
#include <portablethreads/arch/spinlock-pointer-cas.h>
#include <portablethreads/arch/spinlock-atomic-number.h>
#include <portablethreads/arch/free-high-bits-muxer.h>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			template<unsigned USER_BITS, unsigned ALIGNMENT = ALIGNMENT_BITS>
			struct PTPointerCASType
			{
				typedef PointerCAS< FreeHighBitsMuxer<int64, 64, HARDWARE_POINTER_BITS, ALIGNMENT, USER_BITS> > PTPointerCAS;
			};

			typedef PTPointerCASType<0>::PTPointerCAS PTPointerCAS;
		}
	}
}

#endif
