/*  Copyright (c) September 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SPARC_32_V8PLUS_GCC_H
#define SPARC_32_V8PLUS_GCC_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif

#define PT_HAVE_CAS
#define PT_HAVE_CAS2

#include <portablethreads/arch/32-gcc.h>
#include <portablethreads/arch/sparc-v8plus-gcc-common.h>

namespace PortableThreads 
{
	namespace LockFree
	{
		namespace Private
		{

			inline int64 pt_atomic_cas_return_memory(volatile int64* mem, int64 nv, int64 ov)
			{
				__asm__ __volatile__
				(
					"mov %1, %%g1 \n\t"
					"ldx [%2], %%g2 \n\t"
					"ldx [%0], %%g3 \n\t"
					"casx [%%g1], %%g2, %%g3\n\t"
					"membar #StoreLoad | #StoreStore \n\t"
					"stx %%g3, [%0] \n\t"
					:
					: "r"(&nv), "r"(mem), "r"(&ov)
					: "g1", "g2", "g3", "memory"
				);
				
				return nv;
			}

			inline uint64 pt_ticks()
			{
				uint64 ticks;
				__asm__ 
				(
 					"rd %%tick, %%g1 \n\t"
 					"stx %%g1, [%0] \n\t"
 					:
 					: "r"(&ticks)
 					: "g1"
 				);			 	
				return ticks;
			}

			const unsigned HARDWARE_POINTER_BITS = 32;
			const unsigned ALIGNMENT_BITS = 2;
		}
	}
}

#include <portablethreads/arch/arch-common.h>
#include <portablethreads/arch/native-atomic-arithmetic-common.h>
#include <portablethreads/arch/native-pointer-cas.h>
#include <portablethreads/arch/native-atomic-number.h>
#include <portablethreads/arch/free-high-bits-muxer.h>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			template<unsigned USER_BITS, unsigned ALIGNMENT = ALIGNMENT_BITS>
			struct PTPointerCASType
			{
				typedef PointerCAS< FreeHighBitsMuxer<int64, 64, HARDWARE_POINTER_BITS, ALIGNMENT, USER_BITS> > PTPointerCAS;
			};

			typedef PTPointerCASType<0>::PTPointerCAS PTPointerCAS;
		}
	}
}

#endif
