/*  Copyright (c) March 2006 Jean Gressmann (jsg@rz.uni-potsdam.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SPARC_V8_GCC_COMMON_H
#define SPARC_V8_GCC_COMMON_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif


namespace PortableThreads 
{
	// Assembler functions are straight from the linux kernel
	// NOTE: Appearently the pre v8plus architectures don't have 
	// even have simple cas (not to mention cas2)
	// SPARC V8 is a 32-bit CPU with 32-bit addressing!
	namespace LockFree
	{
		namespace Private
		{
			inline int32 pt_atomic_set(volatile int32* mem, int32 val)
			{
				__asm__ __volatile__
					(
					"swap [%2], %0 \n\t"
					: "=&r" (val)
					: "0" (val), "r" (mem)
					: "memory"
					);
				return val;
			}

			inline bool pt_atomic_set_lock(volatile uint8* lock)
			{
				uint32 result;
				__asm__ __volatile__
					(
					"ldstub [%1], %0 \n\t"
					: "=r" (result)
					: "r" (lock)
					: "memory"
					);
				return result == 0;
			}

			inline void pt_atomic_clear_lock(volatile uint8* lock)
			{
				__asm__ __volatile__("stb %%g0, [%0] \n\t" : : "r"(lock) : "memory");
			}
		}
	}
}

#endif
