/*  Copyright (c) March 2006 Jean Gressmann (jsg@rz.uni-potsdam.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SPARC_V8PLUS_GCC_COMMON_H
#define SPARC_V8PLUS_GCC_COMMON_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif

#include <portablethreads/arch/sparc-v8-gcc-common.h>
#include <portablethreads/arch/cas-based-64-bit-atomic-add.h>
#include <portablethreads/arch/cas-based-64-bit-atomic-set.h>

namespace PortableThreads 
{
	namespace LockFree
	{
		namespace Private
		{

			// The SPARC V8+ architecture/abi is a sun-specific thing which has some of the V9's 
			// instructions as well as 64-bit register support.
		
			// prototypes
			inline int64 pt_atomic_cas_return_memory(volatile int64* mem, int64 nv, int64 ov);
			inline uint64 pt_ticks();
	
			/*
			* Atomic compare and exchange.  Compare OLD with MEM, if identical,
			* store NEW in MEM.  Return the initial value in MEM.  Success is
			* indicated by comparing RETURN with OLD.
			*/
			inline int32 pt_atomic_cas_return_memory(volatile int32* mem, int32 nv, int32 ov)
			{
				__asm__ __volatile__("cas [%2], %3, %0 \n\t"
					"membar #StoreLoad | #StoreStore \n\t"
					: "=&r" (nv)
					: "0" (nv), "r" (mem), "r" (ov)
					: "memory");

				return nv;
			}

			inline bool pt_atomic_cas(volatile int32* mem, int32 nv, int32 ov)
			{
				return pt_atomic_cas_return_memory(mem, nv, ov) == ov;
			}


			inline void pt_mfence()
			{
				__asm__ __volatile__("membar #LoadLoad | #LoadStore | #StoreStore | #StoreLoad \n\t" : : : "memory");
			}


			// atomically adds value to counter and returns the result
			inline int32 pt_atomic_add(volatile int32* counter, int32 value)
			{
				int32 current;
				do { current = *counter; } while(!pt_atomic_cas(counter, current+value, current));
				return current + value;
			}

			inline bool pt_atomic_cas(volatile int64* mem, int64 nv, int64 ov)
			{
				return pt_atomic_cas_return_memory(mem, nv, ov) == ov;
			}			
		}
	}

	inline uint64 pt_seed()
	{
		return LockFree::Private::pt_ticks();
	}
}


#endif
