/*  Copyright (c) Febuary 2006 Jean Gressmann (jean@0x42.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PT_MMAP_H
#define PT_MMAP_H
#include <portablethreads/config.h>

namespace PortableThreads 
{
	//!	\brief Returns the size of a memory page on this system.
	unsigned pt_pagesize();

	/*!	\brief Allocate pages of memory

	\param pages Number of pages to allocate.
	\return valid pointer to the allocated memory, or 0 on failure.
	*/
	void* pt_mmap(unsigned long pages);
	
	/*!	\brief Free pages of memory
	\param memory Pointer return by a previous pt_mmap call.
	\param pages Number of pages allocated.
	*/
	void pt_munmap(void* memory, unsigned long pages);
}

#endif
