#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <cassert>

namespace PortableThreads
{
	unsigned pt_pagesize()
	{
		return sysconf(_SC_PAGESIZE);
	}

	static const unsigned PAGESIZE = pt_pagesize();

	void* pt_mmap(unsigned long pages)
	{
		const int dev_zero_fd = open("/dev/zero", O_RDWR);
		assert(dev_zero_fd != -1);
		void* res = mmap(0, pages * PAGESIZE, PROT_READ | PROT_WRITE, MAP_PRIVATE, dev_zero_fd, 0);
		// mmap is required to keep the file open so we can close it
		close(dev_zero_fd);
		return res == MAP_FAILED ? 0 : res;
	}


	void pt_munmap(void* memory, unsigned long pages)
	{
		munmap(memory, pages * PAGESIZE);
	}
}

