/*  Copyright (c) Febuary 2006 Jean Gressmann (jean@0x42.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef UNIX_TLS_H
#define UNIX_TLS_H

#include <portablethreads/config.h>
#include <pthread.h>

namespace PortableThreads 
{
	namespace OSSpecific
	{
		struct PThreadLocalStorage
		{
			typedef pthread_key_t key_type;
			static inline bool create(key_type& key)
			{
				return pthread_key_create(&key, 0) == 0;
			}
			static inline void destroy(key_type id)
			{
				pthread_key_delete(id);
			}
			static inline bool set(key_type id, void* p)
			{
				return pthread_setspecific(id, p) != 0;
			}
			static inline void* get(key_type id)
			{
				return pthread_getspecific(id);
			}
		};
	}
}


#endif
