#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <cassert>

#ifdef max
#	undef max
#endif

namespace PortableThreads
{

	// These functions are mostly due to Doug Lea's malloc implementation
	static unsigned pt_get_pagesize()
	{
		SYSTEM_INFO system_info;
		GetSystemInfo(&system_info);
		return static_cast<unsigned>(system_info.dwPageSize);
	}

	static const unsigned PAGESIZE = pt_get_pagesize();

	unsigned pt_pagesize()
	{
		return PAGESIZE;
	}

	static unsigned DUMMY = pt_pagesize();

	void* pt_mmap(unsigned long pages) 
	{
		void* p;
		do
		{
			p = VirtualAlloc(0, pages * PAGESIZE, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
		}
		while(!p);
		return p;
	}

	void pt_munmap(void* ptr, unsigned long) 
	{
		VirtualFree(ptr, 0, MEM_RELEASE);		
	}
}


