/*  Copyright (c) Febuary 2006 Jean Gressmann (jean@0x42.de)
*
*  This is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version. 
* 
*	This file is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this file; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <portablethreads/lockfree/heap.h>
#include <portablethreads/lockfree/allocator.h>


namespace PortableThreads 
{
	namespace LockFree
	{
		namespace Private
		{
			/**************************************************************/
			/* PTAllocatorBase                                            */
			/**************************************************************/
			PTHeap* PTAllocatorBase::heap_ = &PTHeap::defaultHeap();

		}

		/**************************************************************/
		/* PTUseDefaultHeapMixin                                      */
		/**************************************************************/
		PTHeap* PTUseDefaultHeapMixin::heap_ = &PTHeap::defaultHeap();
		void* PTUseDefaultHeapMixin::operator new(size_t size)
		{
			return heap_->allocate(size);
		}
		void PTUseDefaultHeapMixin::operator delete(void* p, size_t)
		{
			heap_->deallocate(p);
		}
		void* PTUseDefaultHeapMixin::operator new[](size_t size)
		{
			return heap_->allocate(size);
		}
		void PTUseDefaultHeapMixin::operator delete[](void* p, size_t)
		{
			heap_->deallocate(p);
		}
	}
}

