#ifndef STRING_FUNCTIONS_H_INCLUDED
#define STRING_FUNCTIONS_H_INCLUDED
#if defined(_MSC_VER) && (_MSC_VER <= 1200)
#pragma warning (disable : 4786)
#endif

#include <string>
#include <vector>

/** 
 * @namespace StringFunctions
 * Adds some missing but useful string functions to std::string
 */
namespace StringFunctions
{
	
	/**
	 * Returns a string with all characters contained in charList stripped from 
	 * the end of str
	 **/
	inline void trimRight(std::string& str, const std::string& charList = " \t")
	{
		std::string::size_type pos = str.find_last_not_of(charList);
		if (pos != std::string::npos)
			str.erase(pos + 1, std::string::npos);
	}

	/**
	 * Returns a string with all characters contained in charList stripped from 
	 * the beginning of str
	 **/
	inline void trimLeft(std::string& str, const std::string& charList = " \t")
	{
		std::string::size_type pos = str.find_first_not_of(charList);
		if (pos != 0)
			str.erase(0, pos);
	}
	
	/**
	 * Returns an array of strings, each of which is a substring of string 
	 * formed by splitting it on boundaries formed by the string separator. 
	 * If an empty string ("") is used as the separator argument or the seperator
	 * is not contained in str, explode() 
	 * will return an array containing only the string str.
	 **/
	std::vector<std::string > 
	explode(const std::string& separator, const std::string& str);
	
	/**
	 * Splits a string in two pieces using seperator as the boundary.
	 * If str does not contain the seperator, leftSide will be str and
	 * the value of rightSide is undefined.
	 * @return true, if str contains seperator.
	**/
	bool splitHalf(	const std::string& str, 
				const std::string& seperator,
				std::string& leftSide,
				std::string& rightSide);
	
}

#endif
