#ifndef HELPER_H
#define HELPER_H

#include <iostream>
#include <vector>
#include <set>
#include <string>
#include <cstring>
#include <smodels/smodels.h>
#include <smodels/atomrule.h>


const char* const STABLE_MODEL = "Stable Model: ";

inline bool answerSetCompare(std::istream& is1, std::istream& is2)
{
	typedef std::set<std::string> stringset;
	stringset answerSetBuffer1;
	stringset answerSetBuffer2;
	
	const size_t prefixLength = std::strlen(STABLE_MODEL);

	std::string line;
	while(std::getline(is1, line))
	{
		if(line.find(STABLE_MODEL) == 0)
			answerSetBuffer1.insert(line.c_str() + prefixLength);		
	}

	while(std::getline(is2, line))
	{
		if(line.find(STABLE_MODEL) == 0)
			answerSetBuffer2.insert(line.c_str() + prefixLength);		
	}

	return answerSetBuffer1 == answerSetBuffer2;
}

inline std::ostream& smodelsOutput(std::ostream& os, Smodels& smodels)
{
	while (smodels.model ())
	{
		os << STABLE_MODEL;
		for (Node *n = smodels.program.atoms.head (); n; n = n->next)
		{
			if (n->atom->Bpos && n->atom->name)
				os << n->atom->name << ' ';
		}
		os << std::endl;
	}
	return os;
}

inline std::ostream& operator<<(std::ostream& os, Smodels& smodels)
{
	return smodelsOutput(os, smodels);
}

typedef std::vector<std::string> AnswerSet;
typedef std::set<AnswerSet> AnswerSets;


inline void getAllModels(Smodels* smodels, AnswerSets& ass)
{
	while (smodels->model ())
	{
		AnswerSet as;
		for (Node *n = smodels->program.atoms.head (); n; n = n->next)
		{
			if (n->atom->Bpos && n->atom->name)
				as.push_back(n->atom->name);
		}
		ass.insert(as).second;
	}
}


#endif
