/*	$Id: fork.h 1778 2005-05-17 14:37:06Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef FORK_H
#define FORK_H

#include <iosfwd>
#include <cassert>
#include <vector>
#include <memory>
#include <platypus/types_fwd.h>
#include <platypus/types/choice.h>
#include <platypus/distribution_base.h>
#include <distribution/fork/ipc.h>
#include <distribution/fork/printer_thread.h>
#include <portablethreads/lock_free.h>



class NopStream;
namespace Platypus
{
	const char* const FORK_DISTRIBUTION = "fork";

	class Fork	:	public DistributionBase
				,	public PrinterThreadCallback
	{
	public:
		static DistributionBase* create();
		~Fork();
		Fork();
	private: // PrinterThreadCallback
		bool retrieveAnswerSetForPrinting(PartialAssignment& pa);
	private: // BuilderDistributionCallback
		void processCommandLine(int& argc, char** argv);
		void program(const ProgramInterface& prog);
		void output(NopStream& str);
		void options(const PlatypusOptions& values);

		void setup();
	private: // CoreCallback
		bool shutdown();	
		bool delegate(const DelegatableChoice& dc);
		bool needDelegatableChoice() const;
		void fileDelegatableChoiceRequest();
		void cancelDelegatableChoiceRequest();
		bool hasDelegatableChoice();		
		DelegatableChoice delegatableChoice();
		void answerSet(const PartialAssignment& pa);
	private:
		void incExpanderInitializations(size_t inc = 1);
		void incConflicts(size_t inc = 1);
		void incBacktracks(size_t inc = 1);
		void incAnswerSets(size_t inc = 1);
		int id() const;
		void incThreadDelegations(size_t inc = 1);
		void teardown();
		bool print() const { return father_; }
	private: // PlatypusAlgorithmCallback
		void printer(AnswerSetPrinterBase& pr);	
		void terminate();
		std::ostream& print(std::ostream& os) const;
		const std::string& type() const { return type_; }
		size_t expanderInitializations() const;
		size_t conflicts() const;
		size_t answerSetsFound() const;
		size_t backtracks() const;
		size_t threads() const;
		size_t threadDelegations() const;
	private:
		void ensureMessageQueueCapacity();
		bool enoughAnswerSets() const;
		bool receiveDC();
		bool sendDC(const DelegatableChoice& dc);
		void processAnswerSetQueue();
		void fatherSetup();
		void childSetup();
		void setupNumbers();
	private:
		typedef IPC::IPCSHMObject<PortableThreads::LockFree::PTAtomicNumber> SharedAtomicNumber;
		typedef std::vector<SharedAtomicNumber> SharedAtomicNumbers;
		typedef std::vector<PartialAssignment> PAStack;
	private:
		inline PortableThreads::LockFree::PTAtomicNumber& processesThatBelieveQueueIsEmpty() { return numbers_[0]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& processesThatBelieveQueueIsEmpty() const { return numbers_[0]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedInits() { return numbers_[1]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedInits() const { return numbers_[1]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedConflicts() { return numbers_[2]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedConflicts() const { return numbers_[2]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedBacktracks() { return numbers_[3]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedBacktracks() const { return numbers_[3]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedStableModels() { return numbers_[4]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedStableModels() const { return numbers_[4]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedShutdown() { return numbers_[5]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedShutdown() const { return numbers_[5]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedDelegations() { return numbers_[6]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedDelegations() const { return numbers_[6]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedThreadDelegations() { return numbers_[7]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedThreadDelegations() const { return numbers_[7]; }
		inline PortableThreads::LockFree::PTAtomicNumber& sharedTerminationIndicator() { return numbers_[8]; }
		inline const PortableThreads::LockFree::PTAtomicNumber& sharedTerminationIndicator() const { return numbers_[8]; }
	private:
		IPC::IPCMessageBuffer msgBuffer_, printerThreadBuffer_;
		PAStack answerSetsToSend_;
		std::auto_ptr<PrinterThread> printerThread_;
		size_t id_;
		NopStream* os_;
		AnswerSetPrinterBase* printer_;
		DelegatableChoice dc_;
		const ProgramInterface* program_;
		size_t processes_, threads_;
		mutable IPC::IPCMessageQueue ipcBranchQueue_, ipcAnswerSetQueue_;
		IPC::IPCSharedMemory shm_;
		SharedAtomicNumbers numbers_;
		size_t requestedAnswerSets_;
		const bool father_;
		bool suppressAnswerSetPrinting_, hasDC_;
		volatile bool shutdown_;
		
		static const size_t SHMSize;
		static const std::string type_;
	};
}

#endif
