/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_LPARSEREADER_H
#define LIBNOMORE_LPARSEREADER_H

#include <reader.h>

namespace NS_NOMORE {

//! This class builds a graph from a given logic program in lparse format.
/*! 
 * \note Refer to http://www.tcs.hut.fi/Software/smodels/ for more information
 * about lparse.
 */
class LparseReader : public Reader {
public:
  //! Constructs the reader.
  LparseReader();

  //! Destroys the reader.
  ~LparseReader();

  //! Sets up a graph corresponding to the logic program given by the input stream (e.g. a file or stdin)
  /*! \param input The input stream to be read from.
   *  \param[out] graph The graph corresponding to the logic program.
   *  \pre input is in good-state.
   *  \pre It is save to add new Nodes to the graph, i.e. the graph is not yet finalized.
   *  \return returns its second parameter, i.e. the graph-Object.
   *  \throws ReadError if an error occurs while reading from input. */
  Graph& readProgram(std::istream& input, Graph& graph);

	//! Transforms the given graph into a logic program in lparse-format.
	/*! \param os The output stream to which the result is written.
   *  \param graph The graph to be transformed.
   *  \throws WriteError if an error occurs while writing to os. */
  void writeProgram(std::ostream& os, const Graph& graph);

private:
  LparseReader(const LparseReader&);      
  LparseReader& operator=(const LparseReader&);
  class Impl;
};

} // NS_NOMORE

#endif
