#include <nomore/nomore_program.h>
#include <nomore/nomore_program_impl.h>
#include <platypus/factories/registration.h>
#include <platypus/factories/program_factory.h>

namespace Platypus { namespace Nomore {

Program::Program()
    : impl_(new ProgramImpl) 
{}

Program::~Program() 
{
    delete impl_;
}

void Program::setup(std::istream& is) 
{
    impl_->setup(is);
}

std::string Program::idToName(AtomId id) const 
{
    return impl_->idToName(id);
}

const Program::CollectionType& Program::atoms() const
{
    return impl_->atoms();
}

size_t Program::numberOfAtoms() const 
{
    return impl_->numberOfAtoms();
}

size_t Program::numberOfRules() const 
{
    return impl_->numberOfRules();
}

bool Program::hasDisplayName(AtomId id) const 
{
    return impl_->hasDisplayName(id);
}

} } // end namespace Platypus::Nomore

namespace Platypus {

///////////////////////////////////////////////////////////////////////////////
// factory registration code
///////////////////////////////////////////////////////////////////////////////
static ProgramInterface* create() 
{
    return new Nomore::Program;
}

template<>
void factoryRegistration<Platypus::Nomore::Program>()
{
    ProgramFactory::instance().add("nomore", &create);
}

}   // end namespace Platypus
