/*	$Id: types.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <ostream>
#include <cassert>
#include <platypus/algorithm/cout_printer.h>
#include <platypus/types/partial_assignment.h>
#include <platypus/types/atom.h>

namespace Platypus
{
	CoutPrinter::CoutPrinter(std::ostream* os)
		:	os_(os)
	{}
	void CoutPrinter::print(size_t number, const PartialAssignment& pa)
	{
		assert(os_);
		// don't use std::copy here b/c of crummy output with invisible atoms
		*os_ << "Answer: " << static_cast<unsigned long>(number) << "\nStable Model: ";
		const PartialAssignment::CollectionType::const_iterator END = pa.positiveAtoms().end();
		for(PartialAssignment::CollectionType::const_iterator it = pa.positiveAtoms().begin();
			it != END; ++it)
		{
			if(it->visible())
				*os_ << it->name() << ' ';
		}
		*os_ << '\n';
	}
	void CoutPrinter::stream(std::ostream& str)
	{
		os_ = &str;
	}
}
