/*	$Id: pretty_print.cpp 2292 2005-08-05 09:46:52Z kaufmann $
 *
 *  Copyright 2005 University of Potsdam, Germany
 *
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <platypus/algorithm/pretty_print.h>
#include <platypus/smodels_names.h>
#include <platypus/core_names.h>


namespace Platypus
{
	namespace PrettyPrint
	{
		bool expanderCanChoose(const std::string& name)
		{
			if(name == SMODELS_EXPANDER_KEY)
				return true;
			else if(name == "nomore")
			    return true;
			return false;
		}
		bool expanderCanBacktrack(const std::string& name)
		{
			if(name == SMODELS_EXPANDER_KEY)
				return true;
			else if(name == "nomore")
			    return true;
			return false;
		}
		bool multipleThreads(const std::string& name)
		{
			if(name == ST_CORE_KEY)
				return false;
			return true;
		}
	}
}
