/*	$Id: single_threaded_core.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SINGLE_THREADED_CORE_H
#define SINGLE_THREADED_CORE_H

#include <memory>
#include <string>
#include <iosfwd>
#include <platypus/types_fwd.h>
#include <platypus/core_base.h>
#include <platypus/cores/core_callback.h>

class NopStream;
namespace Platypus
{
	class STCallbackAdaptor;
	class Kernel;
	class SingleThreadedCore : public CoreBase
	{
	public:
		static CoreBase* create();
		SingleThreadedCore();
		~SingleThreadedCore();
	private: // BuilderCoreCallback
		void program(ProgramInterface& prog);
		void distribution(CoreDistributionCallback& callback);
		void factory(const PlatypusTypesFactory& factory);
		void output(NopStream& str);
		void options(const PlatypusOptions& values);
		void setup();
	public:
		const std::string& type() const;
		void run();
	private:
		SingleThreadedCore(const SingleThreadedCore&);	
		SingleThreadedCore& operator=(const SingleThreadedCore&);
	private:
		std::auto_ptr<STCallbackAdaptor> adaptor_;
		std::auto_ptr<Kernel> kernel_;
		CoreDistributionCallback* traits_;
		NopStream* os_;

		static const std::string type_;
	};
}

#endif
