/*	$Id: types.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cassert>
#include <platypus/factories/registration.h>
#include <platypus/factories/choice_policy_factory.h>
#include <platypus/types/choice_policy.h>

namespace Platypus
{
	template<>
	void factoryRegistration<ChoicePolicy::RandomTrue>()
	{
		ChoicePolicyFactory::instance().add("random-true", ChoicePolicy::RandomTrue::create, "Random choice, make true");
	}
	template<>
	void factoryRegistration<ChoicePolicy::RandomFalse>()
	{
		ChoicePolicyFactory::instance().add("random-false", ChoicePolicy::RandomFalse::create, "Random choice, make false");
	}
	template<>
	void factoryRegistration<ChoicePolicy::RandomRandom>()
	{
		ChoicePolicyFactory::instance().add("random-random", ChoicePolicy::RandomRandom::create, "Random choice, random truth value");
		ChoicePolicyFactory::instance().add("expander", ChoicePolicy::RandomRandom::create, "Fallback policy is random-random if expander type isn't native chooser");
	}

	namespace ChoicePolicy
	{
		RandomBase::RandomBase()
			:	rng_(static_cast<unsigned long>(PortableThreads::pt_seed()))
		{}
		Choice RandomBase::getChoice(const PossibleChoices& possible, bool positive)
		{
			assert(!possible.empty());
			return Choice(possible[rng_.urand() % possible.size()], positive);
		}
		unsigned long RandomBase::urand()
		{
			return rng_.urand();
		}
		PolicyBase* RandomTrue::clone() const
		{
			return new RandomTrue;
		}
		Choice RandomTrue::getChoice(const PossibleChoices& pc)
		{
			return RandomBase::getChoice(pc, true);
		}
		PolicyBase* RandomTrue::create()
		{
			return new RandomTrue;
		}

		PolicyBase* RandomFalse::clone() const
		{
			return new RandomFalse;
		}
		Choice RandomFalse::getChoice(const PossibleChoices& pc)
		{
			return RandomBase::getChoice(pc, false);
		}
		PolicyBase* RandomFalse::create()
		{
			return new RandomFalse;
		}

		PolicyBase* RandomRandom::clone() const
		{
			return new RandomRandom;
		}
		Choice RandomRandom::getChoice(const PossibleChoices& pc)
		{
			return RandomBase::getChoice(pc, (urand() % 2) != 0);
		}
		PolicyBase* RandomRandom::create()
		{
			return new RandomRandom;
		}
	}
}

